-- Not used by Autodesk MassFX: no localization.

-- PhysX utilities and exporter
try( removerollout px_utility) catch()

utility px_utility "PhysX Plugin" rolledUp:true
(
	timer   simClock  "simulationClock" interval:1 active:false
	-- quitMaxClock is for batch exporting
	timer   quitMaxClock  "delayQuitMax" interval:100 active:false
	
	button  bt_export                       "Export"     tooltip:"Export PhysX scene" across:2
  	button  bt_about                        "About"      tooltip:"Show version information and credits"
  	
  	on bt_export pressed do
  	(
  		global PxExportPxProj_Prompting
  		PxExportPxProj_Prompting(false)
  	)
  	
  	on bt_about pressed do
  	(
  		nvpx.ShowAboutDialog()
  	)

	
	local   lastTime = 0;
	on simClock tick do 
	(
		simClock.active = false
		if animButtonState then	animButtonState = false
	
		tDelta = 1000.0/(frameRate); 
		
		--DETERMINE BURN TIME IF SIMULATING TOO LAST--		
		tStart = timeStamp()
		tEnd = lastTime + tDelta
		if (tEnd > tStart) then
		(
			while timeStamp() < tEnd do
			(
			)
		)
		lastTime = tEnd
		if(lastTime < tStart) then lastTime = tStart
		
		--SIMULATE--
		
		with redraw off 
		(
			undo off
			(
				try
				(
					PxSimulateOneFrame(); 
				) catch ()
			)
		)
		
		redrawviews();

		
		simClock.active = true
		
		if (sliderTime >= animationRange.end) then
		(	
			case gPxOnLastFrame of
			(
				1: slidertime = animationRange.end
				2: PxPauseSimulation()
				3: if gPxLoopAnimation == 1 then (PxStopSimulation(); PxRunSimulation()) else sliderTime = animationRange.start
			)
		)	
	)
	
	on quitMaxClock tick do
	(
		quitMaxClock.active = false
		quitMAX #noPrompt
	)
)

fn PxCheckViewer = 
(
	if (nvpx.ShouldViewerSync()) do
	(
		PxShowViewer()
	)

	-- 
	local vcommand = nvpx.GetViewerCommand()
	if(vcommand == 1) do
	(
		nvpx.SetViewerCommand(0);   -- clear flag to prevent repeat
		PxShowPhysicsPanel(1);      -- see also: VIEWERCOMMAND_SHOW_PHYSXPANEL
		setFocus px_physXPanel
	)
	
	if(vcommand == 2) do            -- restart viewer
	(
		nvpx.SetViewerCommand(0);   -- clear flag to prevent repeat
		PxShowViewer()
	)
	
	nvpx.CheckViewerState()
)

fn PxStartViewerClock = 
(
	global gViewerClock
	gViewerClock.Enabled = true
)

fn PxStopViewerClock = 
(
	global gViewerClock
	gViewerClock.Enabled = false
)

global gViewerClock = dotNetObject "System.Windows.Forms.Timer" 
dotnet.addEventHandler  gViewerClock "tick" PxCheckViewer
gViewerClock.interval = 500
gViewerClock.Enabled = false




-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA4qqEOr+6TNbv9UQqHWO/xdrAqyw3C2YGX
-- 3FIwihee0AFsQUHZNwsEafjRTaSyq+0oWwmPW7lH8lnH7eCdBbrCOaEnyH0w946K
-- ICrckQrsVWVKM2wkakGC46sapB7RKK5ibEnr2koa1kw4XPHOy6B3t+u5U2T4pWul
-- sdTQhsmtqAEpzLji28TKSXNIGvIuO1b0ZOUFsNrirwdV7bklUYDqeMssJRmK7nTY
-- +meHgKjf5yhcTW2h5AmYuyLEJW0WqFqTm0tkswJjC8gEYnrkhHSAkJ4KpVe0FAt2
-- S4v7GFl3+U2YZ3owIPSj5GfDJawTNhjcl+jSjK9kiPc0BEy8tbiW
-- -----END-SIGNATURE-----